package com.hero.objects.modifiers;

import org.jdom.Element;

import com.hero.objects.Adder;

/**
 * Copyright (c) 2000 - 2005, CompNet Design, Inc. All rights reserved.
 * Redistribution and use in source and binary forms, with or without
 * modification, is prohibited unless the following conditions are met: 1.
 * Express written consent of CompNet Design, Inc. is obtained by the developer.
 * 2. Redistributions must retain this copyright notice. THIS SOFTWARE IS
 * PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
 * EVENT SHALL THE COPYRIGHT HOLDERS OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * @author CompNet Design, Inc.
 * @version $Revision$
 */

public class Focus extends Modifier {

	private static String xmlID = "FOCUS";

	public Focus(Element root) {
		super(root, Focus.xmlID);
	}

	@Override
	public String getColumn2Output() {
		String adderString = "";
		String ret = "";
		ret += getAlias();
		if (getSelectedOption() != null) {
			ret = getSelectedOption().getAlias();
		}
		String mobilityString = "";
		String breakabilityString = "";
		String expendabilityString = "";
		String expendabilityString2 = "";
		double val = getTotalValue();
		for (Adder ad : getAssignedAdders()) {
			if (ad.getXMLID().equals("MOBILITY") && ad.getSelectedOption() != null) {
				mobilityString = ad.getSelectedOption().getAlias();
			} else if (ad.getXMLID().equals("BREAKABILITY") && ad.getSelectedOption() != null) {
				breakabilityString = ad.getSelectedOption().getAlias();
			} else if (ad.getXMLID().equals("EXPENDABILITY")) {
				expendabilityString = "Expendable";
				if (ad.getSelectedOption() != null) {
					expendabilityString2 = ad.getSelectedOption().getAlias();
				}
			} else {
				if (adderString.length() > 0) {
					adderString += ", ";
				}
				adderString += ad.getAlias();
				//val -= ad.getBaseCost();
			}
		}
		if ((getInput() != null) && (getInput().trim().length() > 0)) {
			if (ret.trim().length() > 0) {
				ret += ":  ";
			}
			ret += getInput();
		}
		ret += " " + mobilityString;
		ret = ret.trim();
		ret += " " + breakabilityString;
		ret = ret.trim();
		ret += " " + expendabilityString;
		ret = ret.trim();
		for (Modifier mod : getAssignedModifiers()) {
			ret += ", " + mod.getAlias();
		}
		ret += " (";
		if (!getAlias().equals(getDisplay())) {
			ret += getAlias();
			ret += "; ";
		}
		if (expendabilityString2.trim().length() > 0) {
			ret += expendabilityString2 + "; ";
		}
		if (getComments().trim().length() > 0) {
			ret += getComments() + "; ";
		}
		if (adderString.trim().length() > 0) {
			ret += adderString;
			ret += "; ";
		}
		ret += getFraction(val) + ")";
		
		return ret;
	}

	@Override
	public void setSelectedOption(Adder val) {
		String check = getAlias();
		if (check == null) {
			check = getDisplay();
		}
		String doubleCheck = "";
		if (getSelectedOption() != null) {
			doubleCheck = getSelectedOption().getAlias();
			if (doubleCheck == null) {
				doubleCheck = getSelectedOption().getDisplay();
			}
		}
		super.setSelectedOption(val);
	}
}